//
//  MCAssistantAbstractPane.h
//  Assistant
//
//  Created by Alykhan Jetha on 05/04/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCAssistantContentView;

@interface MCAssistantAbstractPane : NSView {
	IBOutlet NSView *contentView;
	NSMutableArray *topLevelObjects;
	
	MCAssistantAbstractPane *previousPane;
	MCAssistantAbstractPane *nextPane;

}


+ (MCAssistantAbstractPane *)createInstanceForPaneClassName:(NSString *)classname 
													  frame:(NSRect)frame;


- (void)autoLocalize;

- (NSMutableArray *)topLevelObjects;
- (void)setTopLevelObjects:(NSMutableArray *)aTopLevelObjects;

- (MCAssistantContentView *)enclosingAssistantContentView;

	// non-retained
- (MCAssistantAbstractPane *)previousPane;
- (void)setPreviousPane:(MCAssistantAbstractPane *)pane;

    // retained
- (MCAssistantAbstractPane *)nextPane;
- (void)setNextPane:(MCAssistantAbstractPane *)pane;

// Subclass reponsibility
- (NSString *)nextPaneClassName;

- (BOOL)isLastPane;
- (BOOL)isFirstPane;


- (NSString *)longTitle;
- (NSString *)bulletName;
- (NSString *)nextPaneButtonTitle;
- (NSString *)previousPaneButtonTitle;
- (BOOL)shouldHidePreviousPaneButton;

- (void)willDisplayInAssistant:(MCAssistantContentView *)assist;
- (void)didDisplayInAssistant:(MCAssistantContentView *)assist;

- (void)willUndisplayInAssistant:(MCAssistantContentView *)assist;
- (void)didUndisplayInAssistant:(MCAssistantContentView *)assist;


- (void)willFinalizeUseInAssistant:(MCAssistantContentView *)assist;
- (void)finalizeUseInAssistant:(MCAssistantContentView *)assist;
- (void)didFinalizeUseInAssistant:(MCAssistantContentView *)assist;

- (BOOL)shouldContinueToNextPane;
- (BOOL)shouldContinueToPreviousPane;
- (BOOL)shouldEnableNextPaneButton;
- (BOOL)shouldEnablePreviousPaneButton;
- (void)validateButtons;

- (void)becomeActiveAssistant;

@end
